<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\Follow;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Tables\User\UserFollowTable;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;

final class UserFollowBuilder implements InterfaceUserFollowSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitUserFollowSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            UserFollowTable::FOLLOWED_USER_ID    => '',
            UserFollowTable::FOLLOWED_BY_USER_ID => '',

            UserFollowTable::META_IS_PENDING     => UserFollowEnum::META_IS_PENDING_NO,

            UserFollowTable::STAMP_REGISTRATION  => System::isoDateTime(),
            UserFollowTable::STAMP_LAST_UPDATE   => System::isoDateTime(),
        );
    }

    public function dispense(): UserFollowModel
    {
        return UserFollowModel::createFromData(
            array(
                // followed user id

                UserFollowTable::FOLLOWED_USER_ID => $this -> followedUserId

                ?? $this -> defaultValues[UserFollowTable::FOLLOWED_USER_ID],

                // followed by user id

                UserFollowTable::FOLLOWED_BY_USER_ID => $this -> followedByUserId

                ?? $this -> defaultValues[UserFollowTable::FOLLOWED_BY_USER_ID],

                // meta is pending

                UserFollowTable::META_IS_PENDING => $this -> metaIsPending

                ?? $this -> defaultValues[UserFollowTable::META_IS_PENDING],

                // stamp registration

                UserFollowTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[UserFollowTable::STAMP_REGISTRATION],

                // stamp last update

                UserFollowTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[UserFollowTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
